#!/usr/bin/perl -w

use Clone qw(clone);
use Test::More;    # tests => 1;
use Test::Differences qw(eq_or_diff);

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_path get_test_data_and_update_if_needed);

use qbit;
use Utils::JSON qw();

run_tests(
    sub {
        my ($app) = @_;

        my $has = from_json readfile(get_test_data_path() . '/data.json');

        my $got = [];
        foreach my $test (@$has) {
            my ($old, $patch, $keys_transform) = @{$test}{qw( old patch keys_transform )};

            my $updated = clone($old);
            Utils::JSON::apply_patch_recursive($updated, clone($patch), $keys_transform);

            push @$got, {%$test, updated => $updated};
        }

        get_test_data_and_update_if_needed('data.json', $got);

        eq_or_diff($got, $has, 'apply_patch_recursive', {context => 5});
    },
);
