use Test::More tests => 1;
use Test::Deep;

use qbit;
use Utils::JSON qw(clean_decoded_json_from_boolean_objects_in_place);

my $json = '{
    "k1" : true,
    "k2" : false,
    "k3" : [
        true,
        {
            "k1" : true,
            "k2" : false,
            "k3" : true
        },
        false
    ],
    "k5"  : 10,
    "k14" : "string4",
    "k6"  : 11,
    "k12" : "string2",
    "k7"  : 12,
    "k13" : "string3",
    "k8"  : 13,
    "k4"  : {
        "k1" : null,
        "k2" : [
            null,
            true,
            null,
            false,
            null,
            true,
            null
        ],
        "k3" : 5
    },
    "k9"  : 14,
    "k11" : "string1",
    "k10" : 15,
    "k15" : "string5"
}';

my $cleaned_json = {
    "k1" => 1,
    "k2" => 0,
    "k3" => [
        1,
        {
            "k1" => 1,
            "k2" => 0,
            "k3" => 1
        },
        0
    ],
    "k5"  => 10,
    "k14" => "string4",
    "k6"  => 11,
    "k12" => "string2",
    "k7"  => 12,
    "k13" => "string3",
    "k8"  => 13,
    "k4"  => {
        "k1" => undef,
        "k2" => [undef, 1, undef, 0, undef, 1, undef],
        "k3" => 5
    },
    "k9"  => 14,
    "k11" => "string1",
    "k10" => 15,
    "k15" => "string5"
};

cmp_deeply(clean_decoded_json_from_boolean_objects_in_place(from_json($json)),
    $cleaned_json, "JSON::XS::Boolean -> to 1/0 replace");
