#!/usr/bin/perl -w

use Clone qw(clone);
use Test::More;    # tests => 1;
use Test::Differences qw(eq_or_diff);

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_path get_test_data_and_update_if_needed);

use qbit;
use Utils::JSON qw();

run_tests(
    sub {
        my ($app) = @_;

        my $has = from_json readfile(get_test_data_path() . '/data.json');

        my $got = [];
        foreach my $test (@$has) {
            my ($patch) = @{$test}{qw( patch )};

            my $updated = clone($patch);
            Utils::JSON::expand_dots_in_patch_recursive($updated);

            push @$got, {%$test, updated => $updated};
        }

        get_test_data_and_update_if_needed('data.json', $got);

        eq_or_diff($got, $has, 'expand_dots_in_patch_recursive', {context => 5});
    },
);
