use strict;
use warnings FATAL => 'all';

use Test::More;

use Utils::LogParser::Checks;

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Mock qw(mock_subs);
use Test::Differences qw(eq_or_diff);

use qbit;

my $FILE_NAME = 'data.json';

# Just read
my $data = get_test_data_and_update_if_needed($FILE_NAME);

plan tests => scalar @$data;

foreach my $test (@$data) {
    my $result = {};
    Utils::LogParser::Checks::access_log_status_juggler($test->{args}{check}, $test->{args}{data}, $result);
    eq_or_diff($result, $test->{result}, $test->{name});
    $test->{result} = $result;
}

# Save if needed
get_test_data_and_update_if_needed($FILE_NAME, $data);

done_testing();
