use strict;
use warnings FATAL => 'all';

use lib::abs;
use File::Temp qw(tempdir);
use Storable;
use Test::More tests => 2;
use Test::Differences qw(eq_or_diff);
use Test::Deep qw(cmp_deeply);

use Utils::LogParser;
use Utils::LogParser::Checks;
use PiConstants;

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Mock qw(mock_subs);
use Test::Partner2::Simple;

use qbit;

# TODO
# добавить обёртку тест для генерации АПП
# добавить проброс АПП в парсер
# добавить проверку ивентов

my $fake_logs_path = lib::abs::path('./logs');
my $fake_state_path = tempdir(CLEANUP => 1);

$Utils::LogParser::Checks::LOGS_DIRECTORY_PATH         = $fake_logs_path;
$Utils::LogParser::Checks::DISK_STORAGE_DIRECTORY_PATH = $fake_state_path;

my @send_to_graphite;
my @send_to_juggler;

mock_subs(
    {
        'Utils::LogParser::Checks::send_to_graphite' => sub {
            my (%data) = @_;

            push @send_to_graphite, \%data;
        },
        'Partner2::Juggler::API::send' => sub {
            my ($api, %data) = @_;

            push @send_to_juggler, \%data;
        },
    }
);

run_tests(
    sub {
        my ($app) = @_;

        $app->set_option('hostname', 'mocked_host');

        Utils::Logger::init();

        Utils::LogParser::Checks::parse_logs($app);

        my $state = Storable::retrieve("$fake_state_path/log_parser_state.bin");
        my %state;
        while (my ($path, $value) = each %$state) {
            $path =~ s/^$fake_logs_path//;
            $state{$path} = $value;
        }

        my $got = {
            graphite => [sort {$a->{path} cmp $b->{path}} @send_to_graphite],
            juggler  => \@send_to_juggler,
            state    => \%state,
        };

        my $has = get_test_data_and_update_if_needed('data.json', $got);
        cmp_deeply($got, $has, 'compare data');

    },
    dont_create_database => 1,
    do_not_die_on_fail   => 1,
);
