use strict;
use warnings FATAL => 'all';

use Test::More;
use Utils::Logger;
use Log::Log4perl;
use Capture::Tiny qw(capture_merged);

sub main_in_test {

    my $config = '
log4perl.logger = DEBUG, Main
log4perl.appender.Main = Log::Log4perl::Appender::Screen
log4perl.appender.Main.layout = Log::Log4perl::Layout::PatternLayout::Multiline
log4perl.appender.Main.layout.ConversionPattern = %C %F %m%n
';

    Log::Log4perl::init(\$config);

    my $got = capture_merged {
        DEBUG 'DEBUG';
        DEBUGF 'DEBUGF %s', 1;
        get_logger->debug('get_logger');
    };

    my $expected = qr{main (\./)?t/lib/Utils/Logger/DEBUG.t DEBUG
main (\./)?t/lib/Utils/Logger/DEBUG.t DEBUGF 1
main (\./)?t/lib/Utils/Logger/DEBUG.t get_logger
};

    like($got, $expected);
    done_testing();

}
main_in_test();
