#!/usr/bin/perl -w

use qbit;
use Test::Partner2::Simple;
use Test::More;
use Utils::MigrationApplier;

run_tests(\&main_test, dont_create_database => 1);

sub main_test {
    my ($app) = @_;
    ok(Utils::MigrationApplier::_is_select_sql("select * from table"),           "select");
    ok(!Utils::MigrationApplier::_is_select_sql("insert from table"),            "insert");
    ok(!Utils::MigrationApplier::_is_select_sql("drop from table"),              "drop");
    ok(!Utils::MigrationApplier::_is_select_sql("create from table"),            "create");
    ok(!Utils::MigrationApplier::_is_select_sql("alter from table"),             "alter");
    ok(!Utils::MigrationApplier::_is_select_sql("delete from table"),            "delete");
    ok(!Utils::MigrationApplier::_is_select_sql("update `my_table` set a = 1;"), "update");

    ok(
        Utils::MigrationApplier::_is_select_sql("
        /*
        comment
        */
        select * from table
        "),
        "select multiline"
      );
    ok(
        !Utils::MigrationApplier::_is_select_sql("
        /*
        comment
        */
        delete from table
        "),
        "delete multiline"
      );

    ok(
        Utils::MigrationApplier::_is_select_sql("
        /*
        PI-111_delete
        */
        select from table
        "),
        "select with ns not word"
      );

    ok(
        !Utils::MigrationApplier::_is_select_sql("
        /*
        PI-111_select
        */
        delete from table
        "),
        "delete with s not word"
      );
}
