#!/usr/bin/perl -w

use Test::Most;
use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);

use qbit;

use Utils::Oneshots;

run_tests(

    sub {
        my ($app) = @_;

        my $count = 0;

        try {
            &Utils::Oneshots::repeater(
                sub {
                    $count++;
                    $app->partner_db->_get_all('select 1');
                },
                0,
                1
            );
        };

        is($count, 1, '1 connection without MySQL error');
        undef($count);

        mock_subs(
            {
                'QBit::Application::Model::DB::_get_all' => sub {
                    throw Exception::DB 'Can\'t connect to MySQL server';
                  }
            }
        );

        try {
            &Utils::Oneshots::repeater(
                sub {
                    $count++;
                    $app->partner_db->_get_all('select 1');
                },
                0,
                2
            );
        };

        is($count, 2, '2 connections when MySQL has error');
        undef($count);

        try {
            &Utils::Oneshots::repeater(
                sub {
                    $count++;
                    $app->partner_db->_get_all('select 1');
                },
                0,
                4
            );
        };

        is($count, 4, '4 connections for 4 tries');
    },
    dont_create_database => 1,
    do_not_die_on_fail   => 1
);
