#!/usr/bin/perl

use Test::Most;
use Test::Deep;

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Partner2::Fixture;

use Capture::Tiny qw(capture_stdout);

use qbit;
use Utils::Oneshots::AddBlockBySample;

my $page_fixture  = 'partner_video_page';
my $block_fixture = 'partner_instream_video_block_vmap';

run_tests(
    sub {
        my ($app) = @_;

        my $target_page  = get_fixture($page_fixture);
        my $sample_block = get_fixture($block_fixture);

        my $sample_data = get_block_data($app, $sample_block);
        my @fields = grep {$_ ne 'moneymap'} keys %{$sample_data->{editable_fields}};

        my $has = get_block_for_page($app, $target_page, \@fields);
        ok(!$has, 'no blocks');

        Utils::Oneshots::AddBlockBySample::main(
            $app,
            {
                sample     => $sample_data->{public_id},
                page_ids   => $target_page->{id},
                skip_empty => 1,
            }
        );
        $has = get_block_for_page($app, $target_page, \@fields);
        ok(!$has, 'no new blocks');

        Utils::Oneshots::AddBlockBySample::main(
            $app,
            {
                sample   => $sample_data->{public_id},
                page_ids => $target_page->{id}
            }
        );
        my $expected = get_block_data($app, $sample_block, \@fields);
        $has = get_block_for_page($app, $target_page, \@fields);
        cmp_deeply($has, $expected, "blocks equive");

        clear_block_for_page($app, $target_page);
        $has = get_block_for_page($app, $target_page, \@fields);
        ok(!$has, 'blocks are deleted');

        Utils::Oneshots::AddBlockBySample::main(
            $app,
            {
                sample        => $sample_data->{public_id},
                page_ids      => $target_page->{id},
                make_readonly => 1,
            }
        );
        $has = get_block_for_page($app, $target_page, \@fields);
        ok($has->{readonly}, 'readonly is set');
        $has->{readonly} = undef;
        cmp_deeply($has, $expected, "blocks equive");
    },
    do_not_die_on_fail => 1,
    fill_databases     => 0,
    fixtures           => [$page_fixture, $block_fixture, 'tns_dict_article', 'picategories_dict'],
);

sub get_block_for_page {
    my ($app, $page, $fields) = @_;

    return $app->video_an_site_instream->get_all(
        filter => [AND => [[page_id => '=' => $page->{id}], [multistate => '=' => 'working']]],
        fields => $fields
    )->[0];
}

sub get_block_data {
    my ($app, $block, $fields) = @_;

    $fields //= ['*'];
    return $app->video_an_site_instream->get_all(
        filter => {
            page_id => $block->{page_id},
            id      => $block->{id},
        },
        fields => $fields
    )->[0];
}

sub clear_block_for_page {
    my ($app, $page) = @_;

    for my $id (
        map {$_->{public_id}} @{
            $app->video_an_site_instream->get_all(
                filter => [AND => [[page_id => '=' => $page->{id}], [multistate => '=' => 'working']]],
                fields => ['public_id']
            )
        }
      )
    {
        $app->video_an_site_instream->do_action($id, "delete");
    }
}
