#!/usr/bin/perl

use Test::Most;
use Test::Deep;

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Partner2::Fixture;
use Test::Partner2::Mock qw(mock_subs restore_subs);
use Test::Differences;

# use Capture::Tiny qw(capture_stdout);

use qbit;
use Utils::Oneshots::AddPageBySample;
use DDP;

my $page_fixture = 'partner_video_page';

run_tests(
    sub {
        my ($app) = @_;

        my $page         = get_fixture($page_fixture);
        my @caption_list = qw/caption1 caption2 caption3/;

        $app->{all_pages} = Test::MockObject::Extends->new($app->{all_pages});
        $app->all_pages->mock(
            'get_all',
            sub {
                return [
                    {
                        page_id => $page->{id},
                        model   => 'video_an_site',
                    }
                ];
            }
        );
        my $public_id = 10;

        $app->{video_an_site} = Test::MockObject::Extends->new($app->{video_an_site});
        $app->video_an_site->mock('add', sub {return ++$public_id});

        my $block_id = 10;

        $app->{video_an_site_instream} = Test::MockObject::Extends->new($app->{video_an_site_instream});
        $app->video_an_site_instream->mock('get_page_id_field_name', sub {return 'page_id'});
        $app->video_an_site_instream->mock('get_add_fields', sub {return {'caption' => 1}});
        $app->video_an_site_instream->mock('get_all', sub {return [{}]});
        $app->video_an_site_instream->mock('add', sub {return ++$block_id});
        $app->video_an_site_instream->mock('force_do_action', sub {return 1});

        restore_subs(['LWP::UserAgent::request']);
        mock_subs(
            {
                'LWP::UserAgent::request' => sub {
                    my ($ua, $request) = @_;
                    my $response = HTTP::Response->new(200);
                    $response->request(HTTP::Request->new());
                    $response->content('{}');
                    return $response;
                  }
            }
        );

        Utils::Oneshots::AddPageBySample::main(
            $app,
            {
                caption_list     => join(',', @caption_list),
                sample_type_only => 'instream',
                caption_mask     => 'AVOD_%s',
                sample           => $page->{id},
            }
        );

        is($public_id, 13, 'pages added');
        is($block_id,  13, 'blocks added');
    },
    fill_databases => 0,
    fixtures       => [$page_fixture, 'tns_dict_article', 'picategories_dict'],
);
