#!/usr/bin/perl

use Test::Most;
use Test::Differences qw(eq_or_diff);

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Partner2::Fixture;
use Test::Partner::DB::Mock;
use Capture::Tiny qw(capture_stdout);

use qbit;
use Utils::Oneshots::FixFilterTagsOnTurbo;

run_tests(
    sub {
        my ($app) = @_;
        mock_curdate('2020-09-10 10:10:10');

        my $stdout = capture_stdout {
            Utils::Oneshots::FixFilterTagsOnTurbo::main($app, {});
        };

        my $expected = get_test_data_and_update_if_needed("data_empty.dump", $stdout, raw => TRUE);
        eq_or_diff($stdout, $expected, "check");
    },
    do_not_die_on_fail => 1,
    fill_databases     => 0,
    fixtures           => ['tns_dict_article', 'picategories_dict'],
    extra_fixtures     => {make_fixture()},
);

sub make_fixture {
    return Test::Partner2::Fixture::DB::Block::context_rtb_block_fixtures(
        fixture_name      => 'block_fixure_with_filter_tags',
        page_fixture_name => 'partner_context_page',
        site_version      => 'turbo',
        design_templates  => [
            {
                caption         => 'design',
                type            => 'tga',
                design_settings => {
                    "css"          => ".css{color:red;}",
                    "grid_columns" => 1,
                    "grid_rows"    => 3,
                    "template"     => "<div class='css'>ads with \${grid_columns} and \${grid_rows}</div>"
                },
                filter_tags => ["fixed", "anysize", "in-content"]
            },
        ],
      ),
      ;
}
