#!/usr/bin/perl

use Test::Most;
use Test::Differences qw(eq_or_diff);

use Test::Partner2::Simple;
use Test::Partner::Utils;

use qbit;
use Utils::Oneshots::FixNativeTemplate;

run_tests(
    \&main_test,
    do_not_die_on_fail   => 1,
    dont_create_database => 1,
);

sub main_test {
    my ($app) = @_;

    my $tests = get_test_data_and_update_if_needed("data.json");
    for my $test (@$tests) {
        if (my $sub = Utils::Oneshots::FixNativeTemplate->can($test->{sub})) {
            $test->{result} = $sub->($test->{template}, $test->{is_content});
        } else {
            $test->{result} = 'bad sub:' . ($test->{sub} // '<undef>');
        }
    }

    my $expected = get_test_data_and_update_if_needed("data.json", $tests);
    eq_or_diff($tests, $expected, "check");
}
