#!/usr/bin/perl

use Test::Most;
use Test::Differences qw(eq_or_diff);

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Partner2::Fixture;
use Test::Partner::DB::Mock;
use Capture::Tiny qw(capture_stdout);

use qbit;
use Utils::Oneshots::MigrationAdfoxScenaries;
use PiConstants qw($IS_PRECISE);

my $block_fixture = 'partner_instream_video_block_vmap';

run_tests(
    sub {
        my ($app) = @_;
        mock_curdate('2020-09-10 10:10:10');

        check($app, 'empty');

        my $block = get_fixture($block_fixture);

        # нет фикстур для сценариев поэтому делаем руками
        $app->partner_db->transaction(
            sub {
                $app->video_an_site->get_next_scenario_id($block->{'page_id'});
            }
        );

        $app->partner_db->video_an_site_instream->edit($block, {adfox_block => 1});
        check($app, 'result');
    },
    do_not_die_on_fail => 1,
    fill_databases     => 0,
    fixtures           => [$block_fixture, 'tns_dict_article', 'picategories_dict'],
);

sub check {
    my ($app, $name) = @_;

    my $stdout = capture_stdout {
        Utils::Oneshots::MigrationAdfoxScenaries::main($app, {});
    };
    my $list = $app->partner_db->video_scenaries->get_all(fields => ['id', 'page_id', 'multistate', 'opts']);

    if ($IS_PRECISE) {
        $stdout =~ s/("id":)"(\d+)"/$1$2/;
        for my $e (@$list) {
            for my $f (qw(id multistate page_id)) {
                $e->{$f} += 0 if exists $e->{$f};
            }
        }
    }
    my $expected = get_test_data_and_update_if_needed("$name.dump", $stdout, raw => TRUE);
    eq_or_diff($stdout, $expected, "check $name");

    my $has = get_test_data_and_update_if_needed("$name.json", $list);
    eq_or_diff($list, $has, "check $name");
}
