#!/usr/bin/perl -w

use Test::More;
use Test::Differences qw(eq_or_diff);

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use qbit;
use Utils::JSON qw();

use Utils::Oneshots::ResendToBk;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $got = {};

        my $status_combinations = [
            ['deleted'],              ['protected'],
            ['rejected'],             [qw( deleted protected )],
            [qw( deleted rejected )], [qw( protected rejected )],
            [qw( deleted protected rejected )]
        ];

        foreach my $page_accessor (@{$app->product_manager->get_page_model_accessors}) {
            my $multistate_graph = $app->$page_accessor->get_multistates_graph_definition();

            foreach my $action_data (@{$multistate_graph->{'multistate_actions'}}) {
                if ($action_data->{'action'} eq 'set_need_update') {

                    my $data = {
                        original => $action_data->{'from'},
                        patched  => {}
                    };

                    foreach my $statuses (@$status_combinations) {
                        my $form_patched =
                          Utils::Oneshots::ResendToBk::fix_action_condition_to_allow_statuses($data->{'original'},
                            $statuses);

                        my $key = sprintf 'allow %s', join ', ', sort @$statuses;
                        $data->{patched}->{$key} = $form_patched;
                    }

                    $got->{$page_accessor} = $data;
                }
            }
        }
        my $has = get_test_data_and_update_if_needed('data.json', $got);

        eq_or_diff($got, $has, 'fix_action_condition_to_allow_statuses', {context => 5});
    }
);
