#!/usr/bin/perl

use Test::Most;
use Test::Differences qw(eq_or_diff);

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Partner2::Fixture;
use Test::Partner::DB::Mock;
use Capture::Tiny qw(capture_stdout);

use qbit;
use Utils::Oneshots::UpdateStoredBKReports;

run_tests(
    sub {
        my ($app) = @_;
        mock_curdate('2020-09-10 10:10:10');
        fill_table($app);

        check($app);

    },
    do_not_die_on_fail => 1,
    fill_databases     => 1,
);

sub check {
    my ($app, $name) = @_;

    my $stdout = capture_stdout {
        Utils::Oneshots::UpdateStoredBKReports::update_reports($app, {});
    };
    my $expected = get_test_data_and_update_if_needed("stdout.dump", $stdout, raw => TRUE);
    eq_or_diff($stdout, $expected, "check stdout");

    my $list = $app->partner_db->stat_report_params_digest->get_all(fields => [qw(id update_date params)]);
    $_->{params} = from_json($_->{params}) for @$list;
    my $has = get_test_data_and_update_if_needed("table.json", $list);
    eq_or_diff($list, $has, "check table");
}

sub fill_table {
    my ($app) = @_;

    my $data = get_test_data_and_update_if_needed("input.json");
    $app->partner_db->stat_report_params_digest->add_multi($data);
}
