#!/usr/bin/perl

use Test::Most;
use Test::Differences qw(eq_or_diff);

use Test::Partner2::Simple;
use Test::Partner::Utils;
use Test::Partner2::Fixture;

use qbit;
use Utils::Oneshots::UserFeature;

run_tests(
    sub {
        my ($app) = @_;

        my $got = {};
        $got->{before} = $app->user_features->get_all(fields => [qw(user_id feature)]);

        Utils::Oneshots::UserFeature::add_feature_to_all_users($app, {feature => 'instream_vmap'});

        $got->{after} = $app->user_features->get_all(fields => [qw(user_id feature)]);

        my $expected = get_test_data_and_update_if_needed("add_feature_to_all_users.dump", $got);
        eq_or_diff($got, $expected, "check");
    },
    do_not_die_on_fail => 1,
    fill_databases     => 0,
    fixtures           => [
        'mocked_yan_partner',   'mocked_mobile_app_partner',
        'mocked_video_partner', 'mocked_video_partner_with_vmap',
        'feature_vmap_for_mocked_video_partner'
    ],
);
