#!/usr/bin/perl

use qbit;
use Test::Partner2::Simple;

use Test::More;
use Test::Differences qw(eq_or_diff);

use Utils::PublicID qw( check_public_ids );

my @wrong = (
    -1, 0, undef, '', 0.1, 'FOO-1', 'FOO-1-2', 'FOO-1-2-3', 'FOO-01-BAR-2', 'FOO-BAR-01-2', 'FOO-BAR-1-02',
    'foo-bar-100-500'
);

my $fixture = {
    'simple ids' => {
        type  => 'simple_id',
        valid => [100500],
        wrong => \@wrong
    },
    'page-block' => {
        type  => 'prefix-page-block',
        valid => ['FOO-BAR-100-500'],
        wrong => [@wrong, '100-500']
    },
    'page-block witр or without prefix' => {
        type  => 'prefix-?page-block',
        valid => ['FOO-BAR-100-500', '100-500'],
        wrong => \@wrong
    },
    'all_valid' => {
        type  => 'simple_id',
        valid => [100500],
        wrong => []
    },
};

run_tests(
    sub {
        my ($app) = @_;

        foreach my $test_name (keys %$fixture) {
            my ($type, $valid, $wrong) = @{$fixture->{$test_name}}{qw( type  valid  wrong  )};
            my $got = check_public_ids([@$valid, @$wrong], $type);

            eq_or_diff($got, $wrong, $test_name);
        }
    },
    dont_create_database => 1
);
