#!/usr/bin/perl

use Test::More;
use Test::Differences (eq_or_diff);
use Test::Exception;

use qbit;
use Test::Partner2::Simple;

use Utils::PublicID qw();

run_tests(
    sub {
        my ($app) = @_;

        my $got = Utils::PublicID::get_block_accessors_by_public_id_prefixes($app);

        my $expect = {
            'D-A-'  => ['context_on_site_direct',          'search_on_site_direct'],
            'D-I-'  => ['internal_context_on_site_direct', 'internal_search_on_site_direct'],
            'I-D-'  => ['indoor_block'],
            'O-D-'  => ['outdoor_block'],
            'P-A-'  => ['search_on_site_premium'],
            'P-I-'  => ['internal_search_on_site_premium'],
            'R-A-'  => ['context_on_site_rtb'],
            'R-AB-' => ['context_on_site_adblock'],
            'R-I-'  => ['internal_context_on_site_rtb'],
            'R-IM-' => ['internal_mobile_app_rtb'],
            'R-M-'  => ['mobile_app_rtb'],
            'R-SA-' => ['ssp_context_on_site_rtb'],
            'R-SM-' => ['ssp_mobile_app_rtb'],
            'R-SV-' => ['ssp_video_an_site_rtb'],
            'R-V-'  => ['video_an_site_instream'],
            'R-VF-' => ['video_an_site_fullscreen'],
            'R-VI-' => ['video_an_site_inpage'],
            'S-A-'  => ['context_on_site_stripe'],
            'S-I-'  => ['internal_context_on_site_stripe'],
            'C-A-'  => ['context_on_site_content'],
            'C-I-'  => ['internal_context_on_site_content'],
            'N-A-'  => ['context_on_site_natural'],
            'N-I-'  => ['internal_context_on_site_natural'],
        };

        eq_or_diff($got, $expect, 'All blocks public_id prefixes');
    },
    dont_create_database => 1
);
