#!/usr/bin/perl

use qbit;
use Test::Partner2::Simple;

use Test::Deep qw(cmp_deeply ignore);
use Test::More;
use Test::Exception;

use Utils::PublicID qw();

run_tests(
    sub {
        my ($app) = @_;

        throws_ok(
            sub {Utils::PublicID::group_public_ids_by_model($app, ['R-A-100-0'])},
            qr/Exception::Validation::BadArguments: No info for zero block/,
            'No info for zero block'
        );

        throws_ok(
            sub {Utils::PublicID::group_public_ids_by_model($app, ['100500-1'])},
            qr/Exception::Validation::BadArguments: Wrong public_id "100500-1"/,
            'Wrong public_id'
        );

        throws_ok(
            sub {Utils::PublicID::group_public_ids_by_model($app, ['FOO-100500-1'])},
            qr/Exception::Validation::BadArguments: Unknown public_id "FOO-100500-1"/,
            'Unknown public_id'
        );

        my $got = Utils::PublicID::group_public_ids_by_model(
            $app,
            [
                qw(
                  R-A-100500-1
                  R-A-100500-2

                  S-A-100500-1
                  S-A-100500-2

                  P-A-100500-1
                  P-A-100500-2

                  R-AB-100500-1
                  R-AB-100500-2

                  R-M-100500-1
                  R-M-100500-2

                  R-V-100500-1
                  R-V-100500-2

                  R-VI-100500-1
                  R-VI-100500-2

                  R-I-100500-1
                  R-I-100500-2

                  S-I-100500-1
                  S-I-100500-2

                  P-I-100500-1
                  P-I-100500-2

                  R-IM-100500-1
                  R-IM-100500-2

                  D-A-100500-1
                  D-A-100500-2

                  D-I-100500-1
                  D-I-100500-2

                  R-SM-100500-1
                  R-SM-100500-2
                  )
            ]
        );

        my $expect = {
            'context_on_site_adblock'         => ['R-AB-100500-1', 'R-AB-100500-2'],
            'context_on_site_direct'          => ['D-A-100500-1',  'D-A-100500-2'],
            'context_on_site_rtb'             => ['R-A-100500-1',  'R-A-100500-2'],
            'context_on_site_stripe'          => ['S-A-100500-1',  'S-A-100500-2'],
            'internal_context_on_site_direct' => ['D-I-100500-1',  'D-I-100500-2'],
            'internal_context_on_site_rtb'    => ['R-I-100500-1',  'R-I-100500-2'],
            'internal_context_on_site_stripe' => ['S-I-100500-1',  'S-I-100500-2'],
            'internal_mobile_app_rtb'         => ['R-IM-100500-1', 'R-IM-100500-2'],
            'internal_search_on_site_direct'  => ['D-I-100500-1',  'D-I-100500-2'],
            'internal_search_on_site_premium' => ['P-I-100500-1',  'P-I-100500-2'],
            'mobile_app_rtb'                  => ['R-M-100500-1',  'R-M-100500-2'],
            'search_on_site_direct'           => ['D-A-100500-1',  'D-A-100500-2'],
            'search_on_site_premium'          => ['P-A-100500-1',  'P-A-100500-2'],
            'ssp_mobile_app_rtb'              => ['R-SM-100500-1', 'R-SM-100500-2'],
            'video_an_site_inpage'            => ['R-VI-100500-1', 'R-VI-100500-2'],
            'video_an_site_instream'          => ['R-V-100500-1',  'R-V-100500-2']
        };

        cmp_deeply($got, $expect, 'All possible public_ids');
    },
    dont_create_database => 1
);
