use strict;
use warnings FATAL => 'all';

use Test::More;
use Utils::PublicID;

sub main_in_test {
    my @valid = qw(
      R-A-41443-1
      R-AF-26254-5
      D-A-142898-1
      S-A-41443-40
      R-AB-153741-4
      MA-A-123-12
      Z-ASDF-100000000000000000-9999999999999
      );

    my @not_valid = qw(
      asdf
      r-a-41443-1
      R-41443-1
      R-A-0-1
      R-A-41443-0
      R-A-041443-1
      R-A-41443-01
      );

    push @not_valid, (' R-A-41443-1 ',);

    foreach my $public_id (@valid) {
        my ($prefix, $page_id, $block_id) = split_block_public_id($public_id);
        is(sprintf('%s%s-%s', $prefix, $page_id, $block_id), $public_id, "$public_id is a valid Public ID");
    }

    foreach my $not_a_public_id (@not_valid) {
        eval {my ($prefix, $page_id, $block_id) = split_block_public_id($not_a_public_id);};

        is(ref($@), 'Exception::Validation::BadArguments', "'$not_a_public_id' is not a valid Public ID");
    }

    done_testing();
}
main_in_test();
