#!/usr/bin/perl

use qbit;
use Test::Partner2::Simple;

use Test::Deep qw(cmp_deeply ignore);
use Test::More;
use Test::Exception;

use Utils::PublicID qw( validate_public_ids );

run_tests(
    sub {
        my ($app) = @_;

        throws_ok(
            sub {validate_public_ids($app, ['R-A-100-0'])},
            qr/Exception::Validation::BadArguments: No info for zero block/,
            'No info for zero block'
        );

        throws_ok(
            sub {validate_public_ids($app, ['132439-1'])},
            qr/Exception::Validation::BadArguments: Wrong public_id "132439-1"/,
            'Wrong public_id'
        );

        throws_ok(
            sub {validate_public_ids($app, ['NO-SUCH-PUBLIC-ID-132439-1'])},
            qr/Exception::Validation::BadArguments: Unknown public_id "NO-SUCH-PUBLIC-ID-132439-1"/,
            'Unknown public_id'
        );

        my ($found, $not_found) = validate_public_ids(
            $app,
            [
                qw(
                  D-A-111161-1
                  D-A-142898-2
                  D-I-118826-1
                  D-I-88849-1
                  P-A-111161-2
                  P-I-128843-1
                  R-A-41443-1
                  R-I-88848-1
                  R-IM-132439-1
                  R-M-43569-1
                  R-V-128972-1
                  R-VI-154689-1
                  S-A-41443-40
                  S-I-148805-1

                  D-A-100500-1
                  D-I-100500-1
                  P-A-100500-2
                  P-I-100500-1
                  R-A-100500-1
                  R-I-100500-1
                  R-IM-100500-1
                  R-M-100500-1
                  R-V-100500-1
                  R-VI-10500-1
                  S-A-100500-1
                  S-I-100500-1
                  )
            ]
        );

        my $expect = {
            'D-A-111161-1'  => 'search_on_site_direct',
            'D-A-142898-2'  => 'context_on_site_direct',
            'D-I-118826-1'  => 'internal_search_on_site_direct',
            'D-I-88849-1'   => 'internal_context_on_site_direct',
            'P-A-111161-2'  => 'search_on_site_premium',
            'P-I-128843-1'  => 'internal_search_on_site_premium',
            'R-A-41443-1'   => 'context_on_site_rtb',
            'R-I-88848-1'   => 'internal_context_on_site_rtb',
            'R-IM-132439-1' => 'internal_mobile_app_rtb',
            'R-M-43569-1'   => 'mobile_app_rtb',
            'R-V-128972-1'  => 'video_an_site_instream',
            'R-VI-154689-1' => 'video_an_site_inpage',
            'S-A-41443-40'  => 'context_on_site_stripe',
            'S-I-148805-1'  => 'internal_context_on_site_stripe'
        };

        cmp_deeply($found, $expect, 'Found public_ids');

        my $expect_no_found = [
            qw(
              D-A-100500-1
              D-I-100500-1
              P-A-100500-2
              P-I-100500-1
              R-A-100500-1
              R-I-100500-1
              R-IM-100500-1
              R-M-100500-1
              R-V-100500-1
              R-VI-10500-1
              S-A-100500-1
              S-I-100500-1
              )
        ];
        cmp_deeply($not_found, $expect_no_found, 'Not found public_ids');
    },
);
