use strict;

use Test::More;
use Test::Deep;

use Utils::Stream::DataSource::Array;

my $tests = [
    {
        array     => [],
        bulk_size => 1,
    },
    {
        array     => [{key => 1, value => 1}, {key => 2, value => 2}, {key => 0, value => 100}],
        bulk_size => 1,
    },
    {
        array     => [{key => 1, value => 1}, {key => 2, value => 2}, {key => 0, value => 100}],
        bulk_size => 4,
    },
];

for my $test (@$tests) {
    my $expected  = $test->{array};
    my $bulk_size = $test->{bulk_size};

    my $data_source = Utils::Stream::DataSource::Array->new(source => $expected);

    my @got;

    while ($data_source->has_next()) {
        push @got, @{$data_source->get_bulk($bulk_size)};
    }

    is_deeply(\@got, $expected, 'Got same array');
}

done_testing();
