use strict;

use Test::More;
use Test::Deep;

use Utils::Stream::DataSource::Array;

my $expected = [{key => 1, value => 1}, {key => 2, value => 2}, {key => 0, value => 100}];

my $data_source = Utils::Stream::DataSource::Array->new(source => $expected);

my @got;

while ($data_source->has_next()) {
    push @got, $data_source->next();
}

is_deeply(\@got, $expected, 'Got same array');

done_testing();
