use strict;

use Test::More;
use Test::Deep;

use Utils::Stream::DataSource::Callback;

my @data = qw(
  1
  2
  3
  4
  5
  );

sub get_data {
    return shift @data;
}

my @expected = ([1], [2, 3], [4, 5],);

my $data_source = Utils::Stream::DataSource::Callback->new(source => \&get_data);

my @got;
my @got;
push @got, $data_source->get_bulk(1);
push @got, $data_source->get_bulk(2);
push @got, $data_source->get_bulk(100);

is_deeply(\@got, \@expected, 'Got same data');

done_testing();
