use strict;

use Test::More;
use Test::Deep;

use Utils::Stream::DataSource::Callback;

my @data = qw(
  1
  2
  3
  );

sub get_data {
    return shift @data;
}

my @expected = @data;

my $data_source = Utils::Stream::DataSource::Callback->new(source => \&get_data);

my @got;
while ($data_source->has_next()) {
    push @got, $data_source->next();
}

is_deeply(\@got, \@expected, 'Got same data');

done_testing();
