use strict;

use qbit;
use Test::More;
use Test::Differences;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Utils::Stream::DataSource::Callback;
use Utils::Stream::Serializer::JSON;
use Utils::Stream::Serializer::XML;
use Utils::Stream::Serializer::TSV;
use Utils::Stream::Writer::Buffer;

my @tests = (
    {
        type       => 'json',
        params     => {pretty => 1, no_headers => 1},
        serializer => 'Utils::Stream::Serializer::JSON',
    },
    {
        type       => 'xml',
        params     => {pretty => 1, no_headers => 1},
        serializer => 'Utils::Stream::Serializer::XML',
    },
    {
        type       => 'tsv',
        params     => {fields => ["a"], no_headers => 1, end_marker => FALSE},
        serializer => 'Utils::Stream::Serializer::TSV',
    },
);
my @data = ({a => 'й'}, {a => 'ц'}, {a => 'у'}, {a => 'к'}, {a => 'е'}, {a => 'н'},);

sub get_callback {
    my @tmp = @data;
    return sub {shift @tmp};
}

for my $test (@tests) {
    my $data       = Utils::Stream::DataSource::Callback->new(source => get_callback());
    my $writer     = Utils::Stream::Writer::Buffer->new();
    my $serializer = $test->{serializer}->new(
        data   => $data,
        writer => $writer,
        %{$test->{params}}
    );

    $serializer->serialize_full(2);
    my $got = $writer->content();
    utf8::decode($got);
    my $expected = get_test_data_and_update_if_needed("result.$test->{type}.dump", $got, raw => TRUE);
    eq_or_diff($got, $expected, $test->{type});
}

done_testing();
