use strict;

use Test::More;
use Test::Deep;

use Utils::Stream::DataSource::FileHandler;

my $data_source = Utils::Stream::DataSource::FileHandler->new(source => \*DATA);

my $expected = [
    [
        '{"a":1}
'
    ],
    [
        '{"a":2}
',
        '{"a":3}
'
    ],
    [
        '{"a":4}
'
    ]
];

my @got;
push @got, $data_source->get_bulk(1);
push @got, $data_source->get_bulk(2);
push @got, $data_source->get_bulk(100);

is_deeply(\@got, $expected, 'Got same data');

done_testing();

__DATA__
{"a":1}
{"a":2}
{"a":3}
{"a":4}
