use strict;

use Test::More;
use Test::Deep;

use Utils::Stream::DataSource::FileHandler;

my $expected = [
    '{"a":1}
',
    '{"a":2}
',
    '{"a":3}
',
    '{"a":4}
'
];

my $data_source = Utils::Stream::DataSource::FileHandler->new(source => \*DATA);

my @got;
while ($data_source->has_next()) {
    push @got, $data_source->next();
}

is_deeply(\@got, $expected, 'Got same data');

done_testing();

__DATA__
{"a":1}
{"a":2}
{"a":3}
{"a":4}
