use strict;

use qbit;
use Test::More;
use Test::Differences;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

use Utils::Stream::DataSource::FileHandler;
use Utils::Stream::Serializer::JSON;
use Utils::Stream::Serializer::XML;
use Utils::Stream::Serializer::TSV;
use Utils::Stream::Writer::Buffer;
use Utils::Stream::DataSource::Array;

my @tests = (
    {
        type       => 'json',
        params     => {pretty => 1},
        serializer => 'Utils::Stream::Serializer::JSON',
    },
    {
        type       => 'xml',
        params     => {pretty => 1},
        serializer => 'Utils::Stream::Serializer::XML',
    },
    {
        type       => 'tsv',
        params     => {fields => ["a"]},
        serializer => 'Utils::Stream::Serializer::TSV',
    },
);

for my $test (@tests) {
    my $data = Utils::Stream::DataSource::FileHandler->new(source => get_fh_for_path("source.$test->{type}.dump"));
    my $writer = Utils::Stream::Writer::Buffer->new();
    my $serializer = $test->{serializer}->new(
        data   => {data => $data},
        writer => $writer,
        %{$test->{params}}
    );

    $serializer->serialize_full(2);
    my $got = $writer->content();
    utf8::decode($got);

    my $expected = get_test_data_and_update_if_needed("result.$test->{type}.dump", $got, raw => TRUE);
    eq_or_diff($got, $expected, $test->{type});
}

done_testing();

sub get_fh_for_path {
    my ($fn) = @_;
    my $path = [caller(0)]->[1];
    $path =~ s/\.t$//;
    open my $fh, "$path/$fn";
    binmode $fh, ":utf8";
    return $fh;
}
