use strict;

use Test::More;
use Test::Deep;

use Utils::Stream::Writer::Buffer;

my $tests = [{writes => [],}, {writes => ['hello'],}, {writes => ['two', ' ', 'words'],}, {writes => ["\n"],},];

foreach my $test (@{$tests}) {
    my $writer = Utils::Stream::Writer::Buffer->new();

    $writer->write($_) for (@{$test->{writes}});
    $writer->clear();

    my $got = $writer->content();

    is($got, '', 'Content is empty');
}

done_testing();
