use strict;

use Test::More;
use Test::Deep;

use Utils::Stream::Writer::Buffer;

my $tests = [
    {
        writes => [],
        result => '',
    },
    {
        writes => ['hello'],
        result => 'hello',
    },
    {
        writes => ['two', ' ', 'words'],
        result => 'two words',
    },
    {
        writes => ["\n"],
        result => "\n",
    },
];

foreach my $test (@{$tests}) {
    my $writer = Utils::Stream::Writer::Buffer->new();

    $writer->write($_) for (@{$test->{writes}});

    my $got      = $writer->content();
    my $expected = $test->{result};

    is($got, $expected, 'Content is correct');
}

done_testing();
