
use Test::More;
use Test::Deep;

use Utils::TSV;

my $tests = [
    {
        tsv => "a\tb
1\t2
11\t22",
        expected_data => [
            {
                a => 1,
                b => 2,
            },
            {
                a => 11,
                b => 22,
            },
        ],
        option => {},
    },
    {
        tsv           => "a\tb",
        expected_data => [],
        option        => {},
    },
    {
        tsv           => "a\tb\n",
        expected_data => [],
        option        => {},
    },
    {
        tsv => "1\t2
11\t22
text1 with\\n\ttext2 with\\t\n",
        expected_data => [
            {
                a => 1,
                b => 2,
            },
            {
                a => 11,
                b => 22,
            },
            {
                a => "text1 with\n",
                b => "text2 with\t",
            },
        ],
        option => {headers => ['a', 'b'], string_escape => 1},
    },
];

foreach my $test (@{$tests}) {
    cmp_deeply(parse_tsv($test->{'tsv'}, %{$test->{'option'}}), $test->{'expected_data'},);
}

done_testing();
