use Test::More;
use Test::Deep;

use Utils::TSV;

my $tsv_tests = [
    {
        data   => [{a => 1, b => 2}, {a => 11, b => 22}, {a => 'text1', b => 'text2'}],
        fields => [qw(a b)],
        option => {},
        expected_data => "a\tb\n1\t2\n11\t22\ntext1\ttext2\n#END\n",
    },
    {
        data   => [{a => 1, b => 2}, {a => 11, b => 22}, {a => "text1 with\n", b => "text2 with\t"}],
        fields => [qw(a b)],
        option        => {without_headers => 1, string_escape => 1},
        expected_data => "1\t2\n11\t22\ntext1 with\\n\ttext2 with\\t\n#END\n",
    },
];

foreach my $test (@{$tsv_tests}) {
    cmp_deeply(tsv_with_fields($test->{'data'}, $test->{'fields'}, %{$test->{'option'}}), $test->{'expected_data'},);
}

done_testing();
