#!/usr/bin/perl -w

use qbit;

use Test::Differences;
use Test::Exception;
use Test::More tests => 3;

use PiConstants;

my $MODEL;
my $PREFIX;

BEGIN {
    $MODEL                         = 'test_model';
    $PREFIX                        = 7;
    %PiConstants::UNIQUE_ID_PREFIX = ($MODEL => $PREFIX);
}

use Utils::UniqueID qw(make_unique_id split_unique_id);

my $PAGE_ID  = 65535;
my $BLOCK_ID = 32767;

my @TEST_DATA = ($PREFIX, $PAGE_ID, $BLOCK_ID);
my $RESULT;
{
    no warnings 'portable';
    $RESULT = 0b00000111_00000000000000001111111111111111_00000000111111111111111;
}

my $unique_id = make_unique_id(@TEST_DATA);
is($unique_id, $RESULT, 'make_unique_id');

my $data = split_unique_id($RESULT);
eq_or_diff($data, \@TEST_DATA, 'split_unique_id');

is(make_unique_id($MODEL, $PAGE_ID, $BLOCK_ID), $RESULT, 'make_unique_id with prefix = model');
