#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Test::More;
use File::Find;
use lib::abs qw();

my $PERL_LIB_DIR   = lib::abs::path('../lib');
my $CARTON_LIB_DIR = lib::abs::path('../local/lib/perl5');

sub get_migrations_files {

    my @files;

    my $project_root = lib::abs::path('../');

    foreach my $stage (qw(before_release after_release)) {
        foreach my $full_file_name (grep {-f} glob lib::abs::path("../migrations/$stage/*")) {
            my $short_file_name = $full_file_name;
            $short_file_name =~ s/\Q$project_root\E\///;
            push @files,
              {
                full_file_name  => $full_file_name,
                short_file_name => $short_file_name,
              };
        }
    }

    return @files;
}

sub main_in_test {
    pass('Loaded ok');

    my @migrations_files = get_migrations_files();

    foreach my $el (@migrations_files) {
        if ($el->{full_file_name} =~ /\.(sql|json|yson|csv)\z/ || -x $el->{full_file_name}) {
            if ($el->{full_file_name} =~ /\.pl\z/) {
                my $shebang_status = system("head -1 $el->{full_file_name} | grep '/usr/bin/perl' > /dev/null");
                if ($shebang_status > 0) {
                    fail($el->{short_file_name});
                    note "Wrong shebang in '$el->{short_file_name}'";
                    next;
                }
                my $compile_status =
                  system("env -i bash -l -c 'perl -I $CARTON_LIB_DIR -I $PERL_LIB_DIR -c $el->{full_file_name}'");
                if ($compile_status > 0) {
                    fail($el->{short_file_name});
                    note "File '$el->{short_file_name}' does not compile. Try 'perl -c' it.";
                    next;
                }
            }
        } else {
            fail($el->{short_file_name});
            note "File '$el->{short_file_name}' must be executable or end with .sql/.json/.yson/.csv";
            next;
        }

        pass($el->{short_file_name});
    }

    done_testing();
}
main_in_test();
