use strict;
use warnings FATAL => 'all';
use Test::More;
use feature 'say';

use lib::abs qw(
  ../lib
  ../t_lib
  );
use TestGraphApplication;

sub get_multistate_start_action_end_text {
    my ($model) = @_;

    my $multistates = $model->get_multistates();

    my $text;

    foreach my $start (sort {$a <=> $b} keys %{$multistates}) {
        foreach my $action (sort keys %{$multistates->{$start}}) {
            $text .= sprintf "%b %s %b\n", $start, $action, $multistates->{$start}->{$action},;
        }
    }

    return $text;
}

sub main_in_test {
    pass('Loaded ok');

    my $app = TestGraphApplication->new();

    is(
        get_multistate_start_action_end_text($app->model),
        '0 edit 0
0 to_archive 1
1 from_archive 0
',
    );

    is($app->model->get_multistate_name(0),   'New');
    is($app->model->get_multistate_name(0b1), 'Archived');

    done_testing();
}
main_in_test();
