package TestApp;

use qbit;

use base qw(QBit::Application);

use QBit::Application::Model::API::ADVQ accessor => 'api_advq';

package main;

use Test::More tests => 1;
use Test::Deep;
use qbit;

my $app = new TestApp();

my $hostname = `hostname`;
chomp($hostname);

$app->pre_run();
$app->set_option(
    api_advq => {
        url              => 'http://localhost:8042/advq/search?',
        phrases_per_page => 50,
        URLs             => {
            $hostname => ['http://test1.advq.yandex.ru', 'http://test2.advq.yandex.ru', 'http://test3.advq.yandex.ru',],
        },
        UrlPath => 'advq/search',
    }
);

my $result;
try {
    $result = $app->api_advq->search((words => ['test', 'world']));
};

my $stat = {
    has_next_page     => ignore(),
    db_info           => ignore(),
    valid_query       => ignore(),
    including_phrases => array_each(
        {
            phrase_guid => ignore(),
            filters     => ignore(),
            phrase      => ignore(),
            cnt         => ignore(),
        }
    ),
    tainted          => ignore(),
    total_count      => ignore(),
    count_by_regions => ignore(),
    overall_time     => ignore(),
    search_time      => ignore(),
    associations     => ignore(),
    db_date_str      => ignore(),
    error            => ignore(),
    precision        => ignore(),
    db_timestamp     => ignore(),
};

#throw Dumper($result);

SKIP: {
    skip 'May be unavalable', 1;
    cmp_deeply($result, [{req => 'test', stat => $stat}, {req => 'world', stat => $stat},],
        "search method result test");
}

$app->post_run();

1;
