#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use 5.010;
use Test::More tests => 6;
use Clone qw(clone);

use qbit;
use Application;

use Exception::Balance::IncorrectAnswer;

my $app = Application->new();
$app->pre_run();

my $data = {
    agency_id      => 0,
    city           => "",
    client_id      => 1304746,
    client_type_id => 0,
    email          => 'ivan@bessarabov.ru',
    fax            => "",
    is_agency      => 0,
    name           => "Бессарабов Иван",
    phone          => "+7 (915) 480 2997",
    url            => ""
};

# Стандартное поведение, когда возвращается один результат.
{
    $app->api_balance->{debug_result} = [0, 0, [$data]];
    is_deeply($app->api_balance->find_client("Login" => "ivanbessarabov"), [$data], 'find_client()');
}

# Нет результатов
{
    $app->api_balance->{debug_result} = [0, 0, []];
    is_deeply($app->api_balance->find_client("Login" => "ivanbessarabov"), [], 'find_client()');
}

# Есть 2 результата
{
    $app->api_balance->{debug_result} = [0, 0, [$data, $data]];
    is_deeply($app->api_balance->find_client("Login" => "ivanbessarabov"), [$data, $data], 'find_client()');
}

# баланс прислал какую-то чушь.
{
    $app->api_balance->{debug_result} = 1;
    my $result;
    try {
        $result = $app->api_balance->find_client("Login" => "ivanbessarabov");
    }
    catch Exception::Balance::IncorrectAnswer with {
        ok(1, 'find_client()');
    };
}

# баланс прислал какую-то чушь.
{
    $app->api_balance->{debug_result} = [1];
    my $result;
    try {
        $result = $app->api_balance->find_client("Login" => "ivanbessarabov");
    }
    catch Exception::Balance::IncorrectAnswer with {
        ok(1, 'find_client()');
    };
}

# Проверяю что возвращается данные именно в canonical формате
{
    my $data2 = clone($data);
    delete $data2->{client_id};
    $data2->{CLIENT_ID} = 123;

    $app->api_balance->{debug_result} = [0, 0, [$data, $data2]];
    my $result = $app->api_balance->find_client("Login" => "ivanbessarabov");

    is_deeply($result->[1]->{client_id}, 123, 'find_client()');
}

$app->post_run();
