package TestApp;

use qbit;
use base qw(QBit::Application);

__PACKAGE__->set_accessors('QBit::Application::Model::API::Yandex::ConvDB' => {'accessor' => 'api_conv_db'});

package main;

use qbit;
use Test::More;
use Test::MockObject::Extends;

my $app = new TestApp();
$app->set_option('url' => 'http://test-url');
$app->set_option('uri' => 'TestAPI');

$app->api_conv_db;

subtest(
    'Date in wrong format is gotten' => sub {
        foreach my $date ('05/05/2013', '2013-05-0_') {
            eval {$app->api_conv_db->get_cpa(date => $date)};

            ok($@, "Method get_cpa throws exception.");
            is($@->{text}, "Date must have format 'yyyy-mm-dd'", "Exception is throwed with the right message.");
        }
    }
);

subtest(
    'Correct get_cpa method call.' => sub {
        my $default_result = 'call result';

        $app->{api_conv_db} = Test::MockObject::Extends->new($app->{api_conv_db});
        $app->{api_conv_db}->mock('call' => sub {to_json($_[3] ? $_[3] : $default_result)});

        subtest(
            'Method call without date.' => sub {
                my $result;
                eval {$result = $app->api_conv_db->get_cpa()};

                is($@, '', "Method get_cpa doesn't throws exception.");
                is($result, $default_result, "Method get_cpa returns the correct result.");
            }
        );
        subtest(
            'Method call with date.' => sub {
                my $result;
                my $date = '2013-05-05';
                eval {$result = $app->api_conv_db->get_cpa('date' => $date)};

                is($@,      '',    "Method get_cpa doesn't throws exception.");
                is($result, $date, "Method get_cpa returns the correct result.");
            }
        );
    }
);

done_testing();
