#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;

use qbit;

use FindBin qw($Bin);
use lib "$Bin/../lib";

use Application;
use QBit::Application::Model::DBManager::Filter::login;

my $app = Application->new();
$app->pre_run();

my $login                   = QBit::Application::Model::DBManager::Filter::login->new();
my $login_field_description = {
    type  => 'login',
    label => d_gettext('Block ID'),
};

is_deeply(
    $login->as_filter(['login', '=', ['yndx.blizzard']], $login_field_description,),
    ['login', '=', \['yndx-blizzard']],
    'as_filter [ "login", "=", [ "yndx.blizzard" ] ]'
);

is_deeply(
    $login->as_filter(['login', '=', 'yndx.blizzard'], $login_field_description,),
    ['login', '=', \'yndx-blizzard'],
    'as_filter [ "login", "=", "yndx.blizzard"]'
);

is_deeply(
    $login->as_filter(['login', 'IN', ['yndx.blizzard']], $login_field_description,),
    ['login', '=', \'yndx-blizzard'],
    'as_filter [ "login", "IN", [ "yndx.blizzard" ] ]'
);

is_deeply(
    $login->as_filter(['login', 'IN', ['Platonov', 'yndx-Ivanov.Ivan']], $login_field_description,),
    ['login', 'IN', \['platonov', 'yndx-ivanov-ivan']],
    'as_filter [ "login", "IN", [ "Platonov", "yndx-Ivanov.Ivan" ] ]'
);

is_deeply(
    $login->as_filter(['login', 'IN', ['Platonov']], $login_field_description,),
    ['login', '=', \'platonov'],
    'as_filter [ "login", "IN", [ "Platonov" ] ]'
);

is_deeply(
    $login->as_filter(['login', 'NOT IN', ['Platonov']], $login_field_description,),
    ['login', '<>', \'platonov'],
    'as_filter [ "login", "NOT IN", [ "Platonov" ] ]'
);

is_deeply(
    $login->as_filter(['login', 'IN', ['Platonov', 'Vecher']], $login_field_description,),
    ['login', 'IN', \['platonov', 'vecher']],
    'as_filter [ "login", "IN", [ "Platonov", "Vecher" ] ]'
);
is_deeply(
    $login->as_filter(['login', 'NOT IN', ['Platonov', 'Vecher']], $login_field_description,),
    ['login', 'NOT IN', \['platonov', 'vecher']],
    'as_filter [ "login", "NOT IN", [ "Platonov", "Vecher" ] ]'
);
is_deeply(
    $login->as_filter(['login', 'LIKE', 'Platonov'], $login_field_description,),
    ['login', 'LIKE', \'%platonov%'],
    'as_filter [ "login", "LIKE", "Platonov" ]'
);
is_deeply(
    $login->as_filter(['login', 'NOT LIKE', 'Platonov'], $login_field_description,),
    ['login', 'NOT LIKE', \'%platonov%'],
    'as_filter [ "login", "NOT LIKE", "Platonov" ]'
);

done_testing();
