#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;

use qbit;
use Application;
use QBit::Application::Model::DBManager::Filter::publicid;

my $app = Application->new();
$app->pre_run();

my $publicid               = QBit::Application::Model::DBManager::Filter::publicid->new();
my $public_id_model_filter = {
    type   => 'publicid',
    label  => d_gettext('Block ID'),
    regexp => {
        '^([0-9]+)$'             => [qw(id)],
        '^RI-([0-9]+)-([0-9]+)$' => [qw(campaign_id id)],
    },
};

is_deeply(
    $publicid->as_filter(["id" => "NOT IN" => ["RI-115110-1", 2]], $public_id_model_filter,),
    [
        'AND',
        [
            {
                'NOT' => [
                    [
                        'AND',
                        [['AND', [['campaign_id', 'IN', \['115110']], ['id', 'IN', \['1']]]], ['id', 'IN', \['2']]]
                    ]
                ]
            }
        ]
    ],
    'as_filter [ "id" => "NOT IN" => ["RI-115110-1", 2] ]'
);

is_deeply(
    $publicid->as_filter(["id" => "IN" => ["RI-115110-1", 2]], $public_id_model_filter,),
    ['OR' => [['AND', [['campaign_id', 'IN', \['115110']], ['id', 'IN', \['1']]]], ['id', 'IN', \['2']]]],
    'as_filter [ "id" => "IN" => ["RI-115110-1", 2] ]'
);

is_deeply(
    $publicid->as_filter(["id" => "IN" => ["RI-115110-1"]], $public_id_model_filter,),
    ['OR' => [['AND', [['campaign_id', 'IN', \['115110']], ['id', 'IN', \['1']]]],]],
    'as_filter [ "id" => "IN" => ["RI-115110-1"] ]'
);

is_deeply(
    $publicid->as_filter(["id" => "IN" => [1, 2]], $public_id_model_filter,),
    ['OR' => [['id', 'IN', \['1']], ['id', 'IN', \['2']],]],
    'as_filter [ "id" => "IN" => [1, 2] ]'
);

is_deeply(
    $publicid->as_filter(["id" => "<>" => "RI-115110-1"], $public_id_model_filter,),
    ['AND', [{'NOT' => [['AND', [['campaign_id', '=', \'115110'], ['id', '=', \'1']]]]}]],
    'as_filter [ "id" => "<>" => "RI-115110-1" ]'
);

is_deeply(
    $publicid->as_filter(["id" => "<>" => "RI-115110-1"], $public_id_model_filter,),
    ['AND', [{'NOT' => [['AND', [['campaign_id', '=', \'115110'], ['id', '=', \'1']]]]}]],
    'as_filter [ "id" => "<>" => "RI-115110-1" ]'
);

is_deeply(
    $publicid->as_filter(["id" => "=" => "RI-115110-1"], $public_id_model_filter,),
    ['AND', [['campaign_id', '=', \'115110'], ['id', '=', \'1']]],
    'as_filter [ "id" => "=" => "RI-115110-1" ]'
);

is_deeply(
    $publicid->as_filter(["id" => "<>" => "1"], $public_id_model_filter,),
    ['AND', [{'NOT' => [['id', '=', \'1']]}]],
    'as_filter [ "id" => "<>" => "1" ]'
);

is_deeply(
    $publicid->as_filter(["id" => "=" => "1"], $public_id_model_filter,),
    ['id', '=', \'1'],
    'as_filter [ "id" => "=" => "1" ]'
);

is($publicid->as_text(["id" => "=" => 1],), 'id = 1', 'as_text [ "id" => "=" => 1 ]');

is($publicid->as_text(["id" => "<>" => 1],), 'id <> 1', 'as_text [ "id" => "<>" => 1 ]');

is(
    $publicid->as_text(["id" => "IN" => [1, "RI-115110-2"]],),
    'id IN [1, RI-115110-2]',
    'as_text [ "id" => "IN" => [1, "RI-115110-2"] ]'
  );

is(
    $publicid->as_text(["id" => "NOT IN" => [1, "RI-115110-2"]],),
    'id NOT IN [1, RI-115110-2]',
    'as_text [ "id" => "NOT IN" => [1, "RI-115110-2"] ]'
  );

done_testing();
