use Test::More;

BEGIN {
    if (!eval q{ use Test::Differences; 1 }) {
        *eq_or_diff = \&is_deeply;
    }
}

use qbit;

use QBit::WebInterface::Controller::BEMHTML::Form::Field::authority_document;

my $ad = QBit::WebInterface::Controller::BEMHTML::Form::Field::authority_document->new();

eq_or_diff(
    $ad->_get_doc_types(),
    [
        {
            label     => "Charter",
            no_date   => 1,
            no_number => 1,
            value     => 1,
        },
        {
            label => "Power of attorney",
            value => 2,
        },
        {
            label => "Order",
            value => 3,
        },
        {
            label => "Instruction",
            value => 4,
        },
        {
            label => "Branch regulations",
            value => 5,
        },
        {
            label => "Registration certificate",
            value => 6,
        },
        {
            label => "Contract",
            value => 7,
        },
        {
            label => "Protocol",
            value => 8,
        },
    ],
    '_get_doc_types()',
);

eq_or_diff(
    $ad->_get_doc_types(subtype => 'ur'),
    [
        {
            label     => "Charter",
            no_date   => 1,
            no_number => 1,
            value     => 1,
        },
        {
            label => "Power of attorney",
            value => 2,
        },
        {
            label => "Order",
            value => 3,
        },
        {
            label => "Instruction",
            value => 4,
        },
        {
            label => "Branch regulations",
            value => 5,
        },
    ],
    "_get_doc_types( subtype => 'ur' )",
);

eq_or_diff(
    $ad->_get_doc_types(subtype => 'ip'),
    [
        {
            label => "Registration certificate",
            value => 6,
        },
    ],
    "_get_doc_types( subtype => 'ip' )",
);

eq_or_diff(
    $ad->_get_doc_type_by_id(1),
    {
        label     => "Charter",
        no_date   => 1,
        no_number => 1,
        value     => 1,
    },
    "_get_doc_type_by_id(1)",
);

eq_or_diff(
    $ad->_get_doc_type_by_id(1, subtype => 'ur'),
    {
        label     => "Charter",
        no_date   => 1,
        no_number => 1,
        value     => 1,
    },
    "_get_doc_type_by_id(1, subtype => 'ur')",
);

eq_or_diff($ad->_get_doc_type_by_id(1, subtype => 'ip'), undef, "_get_doc_type_by_id(1, subtype => 'ip')",);

done_testing();

__END__
