use Test::More;
use Test::MockObject;
use Test::Deep;

use qbit;
use Application;

use QBit::WebInterface::Controller::Form;
use QBit::WebInterface::Controller::BEMHTML::Form::Field::date;

sub check_correct_date_no_limits {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::date->new(
        name => 'day_of_birth',
        form => $form,
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'day_of_birth') {
                return '2000-01-01';
            } else {
                return '';
            }
        },
    );

    eval {$field->process($controller);};

    is("$@", '', 'Got no error');

    cmp_deeply($field->value(), '2000-01-01', 'Got expected value',);

    return FALSE;
}

sub check_incorrect_date_no_limits {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::date->new(
        name => 'day_of_birth',
        form => $form,
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'day_of_birth') {
                return 'asdf';
            } else {
                return '';
            }
        },
    );

    eval {$field->process($controller);};

    like($@, qr/Incorrect date/, 'Got expected error',);

    return FALSE;
}

sub check_correct_date_eq_min_limit {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::date->new(
        name     => 'day_of_birth',
        form     => $form,
        min_date => '2000-01-01',
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'day_of_birth') {
                return '2000-01-01';
            } else {
                return '';
            }
        },
    );

    eval {$field->process($controller);};

    is("$@", '', 'Got no error');

    cmp_deeply($field->value(), '2000-01-01', 'Got expected value',);

    return FALSE;
}

sub check_correct_date_gt_min_limit {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::date->new(
        name     => 'day_of_birth',
        form     => $form,
        min_date => '2000-01-01',
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'day_of_birth') {
                return '2010-01-01';
            } else {
                return '';
            }
        },
    );

    eval {$field->process($controller);};

    is("$@", '', 'Got no error');

    cmp_deeply($field->value(), '2010-01-01', 'Got expected value',);

    return FALSE;
}

sub check_incorrect_date_min_limit {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::date->new(
        name     => 'day_of_birth',
        form     => $form,
        min_date => '2000-01-01',
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'day_of_birth') {
                return '1999-01-01';
            } else {
                return '';
            }
        },
    );

    eval {$field->process($controller);};

    like($@, qr/Incorrect date/, 'Got expected error',);

    return FALSE;
}

sub check_correct_date_eq_max_limit {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::date->new(
        name     => 'day_of_birth',
        form     => $form,
        max_date => '2000-01-01',
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'day_of_birth') {
                return '2000-01-01';
            } else {
                return '';
            }
        },
    );

    eval {$field->process($controller);};

    is("$@", '', 'Got no error');

    cmp_deeply($field->value(), '2000-01-01', 'Got expected value',);

    return FALSE;
}

sub check_correct_date_lt_max_limit {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::date->new(
        name     => 'day_of_birth',
        form     => $form,
        max_date => '2000-01-01',
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'day_of_birth') {
                return '1999-01-01';
            } else {
                return '';
            }
        },
    );

    eval {$field->process($controller);};

    is("$@", '', 'Got no error');

    cmp_deeply($field->value(), '1999-01-01', 'Got expected value',);

    return FALSE;
}

sub check_incorrect_date_max_limit {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::date->new(
        name     => 'day_of_birth',
        form     => $form,
        max_date => '2000-01-01',
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'day_of_birth') {
                return '2000-01-02';
            } else {
                return '';
            }
        },
    );

    eval {$field->process($controller);};

    like($@, qr/Incorrect date/, 'Got expected error',);

    return FALSE;
}

sub check_correct_date_min_max_limit {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::date->new(
        name     => 'day_of_birth',
        form     => $form,
        min_date => '1900-01-01',
        max_date => '2000-01-01',
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'day_of_birth') {
                return '1980-05-06';
            } else {
                return '';
            }
        },
    );

    eval {$field->process($controller);};

    is("$@", '', 'Got no error');

    cmp_deeply($field->value(), '1980-05-06', 'Got expected value',);

    return FALSE;
}

sub _get_mocked_form {
    my $form_controller = Test::MockObject->new();

    $form_controller->mock(
        'app',
        sub {
            my $app = Application->new();
            $app->pre_run();

            $app->set_app_locale('en');

            return $app;
        }
    );

    my $form = Test::MockObject->new();
    $form->mock('controller', sub {return $form_controller});

    return $form;
}

sub _get_mocked_controller {
    my (%opts) = @_;

    my $request = Test::MockObject->new();
    $request->mock('param', $opts{'param'});

    my $controller = Test::MockObject->new();
    $controller->mock('request', sub {return $request});

    return $controller;
}

sub main {

    pass('Loaded ok');

    check_correct_date_no_limits();
    check_incorrect_date_no_limits();

    check_correct_date_eq_min_limit();
    check_correct_date_gt_min_limit();
    check_incorrect_date_min_limit();

    check_correct_date_eq_max_limit();
    check_correct_date_lt_max_limit();
    check_incorrect_date_max_limit();

    check_correct_date_min_max_limit();

    done_testing();

}
main();
