use Test::More;

use qbit;

use QBit::WebInterface::Controller::Form;
use QBit::WebInterface::Controller::BEMHTML::Form::Field::number_and_optional_spaces;

sub check_correct_values_count_4 {

    my @v = ('1234', '12 34', '1 2 3 4', ' 1 2 3 4 ', '0123');

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::number_and_optional_spaces->new();

    $field->{count} = 4;

    foreach my $v (@v) {
        $field->{'value'} = $v;
        my $result;
        eval {$result = $field->check();};
        ok($result, "'$v' is valid");
    }

}

sub check_incorrect_values_count_4 {
    my @v = ('123', '12 3', 'asdf', '1234a');

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::number_and_optional_spaces->new();

    $field->{count} = 4;

    foreach my $v (@v) {
        $field->{'value'} = $v;

        eval {$field->check();};

        $v = 'undef' if not defined $v;
        like($@, qr/Invalid/, "'$v' is not valid");
    }
}

sub check_correct_values_count_6 {

    my @v = ('123456', '123 456');

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::number_and_optional_spaces->new();

    $field->{count} = 6;

    foreach my $v (@v) {
        $field->{'value'} = $v;
        my $result;
        eval {$result = $field->check();};
        ok($result, "'$v' is valid");
    }

}

sub check_incorrect_values_count_6 {
    my @v = ('1234');

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::number_and_optional_spaces->new();

    $field->{count} = 6;

    foreach my $v (@v) {
        $field->{'value'} = $v;

        eval {$field->check();};

        $v = 'undef' if not defined $v;
        like($@, qr/Invalid/, "'$v' is not valid");
    }
}

sub main {

    pass('Loaded ok');

    check_correct_values_count_4();
    check_incorrect_values_count_4();

    check_correct_values_count_6();
    check_incorrect_values_count_6();

    done_testing();

}
main();
