#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Carp;

use Test::More;
use Test::Deep;
use Test::MockObject;

use lib::abs qw(
  ../lib
  );
use QBit::WebInterface::Controller::BEMHTML::Form::Field::pfr;

# global vars

# subs
sub check_set_value {
    my $request = Test::MockObject->new();
    $request->set_series('param', 112, 233, 445, 95,);

    my $controller = Test::MockObject->new();
    $controller->mock('request', sub {return $request});

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::pfr->new(name => 'pfr',);
    $field->process($controller);

    cmp_deeply(
        $field->value,
        {
            pfr => '112-233-445 95',
            raw => {
                pfr1 => 112,
                pfr2 => 233,
                pfr3 => 445,
                pfr4 => 95,
            },
        },
        'Gor correct value',
    );

}

sub check_correct_value {
    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::pfr->new(
        name  => 'pfr',
        value => {
            pfr => '112-233-445 95',
            raw => {
                pfr1 => 112,
                pfr2 => 233,
                pfr3 => 445,
                pfr4 => 95,
            },
        },
    );

    eval {$field->check();};

    is($@, '', '$field->check() does not throw exception for correct value',);

    return '';
}

sub check_incorrect_value {
    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::pfr->new(
        name  => 'pfr',
        value => {
            pfr => '112-233-445 ab',
            raw => {
                pfr1 => 112,
                pfr2 => 233,
                pfr3 => 445,
                pfr4 => 'ab',
            },
        },
    );

    eval {$field->check();};

    is(ref($@), 'Exception::Form', '$field->check() throws exception for incorrect value',);

    return '';
}

# main
sub main {

    pass('Loaded ok');

    check_set_value();
    check_correct_value();
    check_incorrect_value();

    done_testing();

}
main();
__END__
