use Test::More skip_all => 'server yamoney is broken';
use Test::MockObject;
use Test::Deep;

use qbit;
use Application;

use QBit::WebInterface::Controller::Form;
use QBit::WebInterface::Controller::BEMHTML::Form::Field::ph_payments;

sub check_correct_yamoney {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::ph_payments->new(
        name => 'payments',
        form => $form,
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'payments__type') {
                return 'yamoney';
            } elsif ($name eq 'payments__yamoney_account') {
                return '41003430872571';
            } elsif ($name eq 'lname') {
                return 'Партнерская';
            } elsif ($name eq 'fname') {
                return 'Сеть';
            } elsif ($name eq 'mname') {
                return 'Яндекса';
            } elsif ($name eq 'passport-s') {
                return '4007';
            } elsif ($name eq 'passport-n') {
                return '123456';
            } else {
                return '';
            }
        },
    );

    $field->process($controller);

    cmp_deeply(
        $field->value(),
        {
            yamoney_account => '41003430872571',
            type            => 'yamoney',
            raw             => {
                type                      => 'yamoney',
                yamoney_account           => '41003430872571',
                bankbic                   => '',
                'sberbank-person-account' => '',
                'sberbank-account'        => '',
                'otherbank-account'       => '',
            },
        },
        'Got expected value',
    );

    return FALSE;
}

sub check_incorrect_yamoney {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::ph_payments->new(
        name => 'payments',
        form => $form,
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'payments__type') {
                return 'yamoney';
            } elsif ($name eq 'payments__yamoney_account') {
                return '123';
            } else {
                return '';
            }
        },
    );

    eval {$field->process($controller);};
    my $err = $@;

    is(ref($err), 'Exception::Form', 'Got correct exception with incorrect Yandex.Money account',);

    cmp_deeply(
        $field->value(),
        {
            raw => {
                type                      => 'yamoney',
                yamoney_account           => '123',
                bankbic                   => '',
                'sberbank-person-account' => '',
                'sberbank-account'        => '',
                'otherbank-account'       => '',
            },
        },
        'Got expected value',
    );

    cmp_deeply(
        $field->{control_errors},
        {yamoney_account => "Incorrect Yandex.Money account number",},
        'got expected control_errors'
    );

    return FALSE;
}

sub check_correct_sberbank {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::ph_payments->new(
        name => 'payments',
        form => $form,
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'payments__type') {
                return 'sberbank';
            } elsif ($name eq 'payments__bankbic') {
                return '046577674';
            } elsif ($name eq 'payments__sberbank-person-account') {
                return '42307810755073104366/39';
            } elsif ($name eq 'payments__sberbank-account') {
                return '40817810416000975145';
            } else {
                return '';
            }
        },
    );

    $field->process($controller);

    cmp_deeply(
        $field->value(),
        {
            type                      => 'sberbank',
            bankbic                   => '046577674',
            'sberbank-person-account' => '42307810755073104366/39',
            'sberbank-account'        => '40817810416000975145',
            raw                       => {
                type                      => 'sberbank',
                bankbic                   => '046577674',
                'sberbank-person-account' => '42307810755073104366/39',
                'sberbank-account'        => '40817810416000975145',
                'otherbank-account'       => '',
                yamoney_account           => '',
            },
        },
        'Got expected value',
    );

    return FALSE;
}

sub check_incorrect_sberbank {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::ph_payments->new(
        name => 'payments',
        form => $form,
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'payments__type') {
                return 'sberbank';
            } elsif ($name eq 'payments__bankbic') {
                return '044030653';
            } elsif ($name eq 'payments__sberbank-person-account') {
                return '66/39';
            } elsif ($name eq 'payments__sberbank-account') {
                return '3030181095500060550';
            } else {
                return '';
            }
        },
    );

    eval {$field->process($controller);};

    my $err = $@;

    is(ref($err), 'Exception::Form', 'Got correct exception with incorrect sberbank person account',);

    cmp_deeply(
        $field->value(),
        {
            raw => {
                type                      => 'sberbank',
                bankbic                   => '044030653',
                'sberbank-person-account' => '66/39',
                'sberbank-account'        => '3030181095500060550',
                'otherbank-account'       => '',
                yamoney_account           => '',
            },
        },
        'Got expected value',
    );

    cmp_deeply(
        $field->{control_errors},
        {
            'sberbank-person-account' => "Incorrect person account",
            'sberbank-account'        => "Incorrect account",
        },
        'got expected control_errors'
    );

    return FALSE;
}

sub check_correct_otherbank {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::ph_payments->new(
        name => 'payments',
        form => $form,
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'payments__type') {
                return 'otherbank';
            } elsif ($name eq 'payments__bankbic') {
                return '044525593';
            } elsif ($name eq 'payments__otherbank-account') {
                return '40817810004210005493';
            } else {
                return '';
            }
        },
    );

    $field->process($controller);

    cmp_deeply(
        $field->value(),
        {
            type                => 'otherbank',
            bankbic             => '044525593',
            'otherbank-account' => '40817810004210005493',
            raw                 => {
                type                      => 'otherbank',
                bankbic                   => '044525593',
                'sberbank-person-account' => '',
                'sberbank-account'        => '',
                'otherbank-account'       => '40817810004210005493',
                yamoney_account           => '',
            },
        },
        'Got expected value',
    );

    return FALSE;
}

sub check_incorrect_otherbank {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::ph_payments->new(
        name => 'payments',
        form => $form,
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'payments__type') {
                return 'otherbank';
            } elsif ($name eq 'payments__bankbic') {
                return '044525593';
            } elsif ($name eq 'payments__otherbank-account') {
                return '40817810004210005492';
            } else {
                return '';
            }
        },
    );

    eval {$field->process($controller);};

    my $err = $@;

    is(ref($err), 'Exception::Form', 'Got correct exception with incorrect otherbank account',);

    cmp_deeply(
        $field->value(),
        {
            raw => {
                type                      => 'otherbank',
                bankbic                   => '044525593',
                'sberbank-person-account' => '',
                'sberbank-account'        => '',
                'otherbank-account'       => '40817810004210005492',
                yamoney_account           => '',
            },
        },
        'Got expected value',
    );

    cmp_deeply($field->{control_errors}, {'otherbank-account' => "Incorrect account",}, 'got expected control_errors');

    return FALSE;
}

sub check_otherbank_account_without_bic {

    my $form = _get_mocked_form();

    my $field = QBit::WebInterface::Controller::BEMHTML::Form::Field::ph_payments->new(
        name => 'payments',
        form => $form,
    );

    my $controller = _get_mocked_controller(
        param => sub {
            my ($self, $name) = @_;

            if ($name eq 'payments__type') {
                return 'otherbank';
            } elsif ($name eq 'payments__otherbank-account') {
                return '40817810004210005492';
            } else {
                return '';
            }
        },
    );

    eval {$field->process($controller);};

    my $err = $@;

    is(ref($err), 'Exception::Form', 'Got correct exception with incorrect otherbank account',);

    cmp_deeply(
        $field->value(),
        {
            raw => {
                type                      => 'otherbank',
                bankbic                   => '',
                'sberbank-person-account' => '',
                'sberbank-account'        => '',
                'otherbank-account'       => '40817810004210005492',
                yamoney_account           => '',
            },
        },
        'Got expected value',
    );

    cmp_deeply(
        $field->{control_errors},
        {
            'bankbic'           => 'Required field',
            'otherbank-account' => "Incorrect account",
        },
        'got expected control_errors',
    );

    return FALSE;
}

sub _get_mocked_form {
    my $form_controller = Test::MockObject->new();

    $form_controller->mock(
        'app',
        sub {
            my $app = Application->new();
            $app->pre_run();

            $app->set_app_locale('en');

            return $app;
        }
    );

    my $form = Test::MockObject->new();
    $form->mock('controller', sub {return $form_controller});

    return $form;
}

sub _get_mocked_controller {
    my (%opts) = @_;

    my $request = Test::MockObject->new();
    $request->mock('param', $opts{'param'});

    my $controller = Test::MockObject->new();
    $controller->mock('request', sub {return $request});

    return $controller;
}

sub main {

    pass('Loaded ok');

    check_correct_yamoney();
    check_incorrect_yamoney();

    check_correct_sberbank();
    check_incorrect_sberbank();

    check_correct_otherbank();
    check_incorrect_otherbank();
    check_otherbank_account_without_bic();

    done_testing();

}
main();
