#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        ok($app->check_rights('NOT_EXISTS'), 'In test by default - all righrs');

        $app->{'__CURRENT_USER_RIGHTS__'} = {};

        ok(!$app->check_rights('NOT_EXISTS'), 'No rights');

        my $tmp_rihts = $app->add_tmp_rights('tmp_rights');

        ok($app->check_rights('tmp_rights'), 'tmp_rights exists');

        undef($tmp_rihts);

        ok(!$app->check_rights('tmp_rights'), 'tmp_rights not exists');
    },
);
