use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;

my %USER_ID2LOGIN;

sub get_login_by_user_id {
    my ($app, $user_id) = @_;

    if ($USER_ID2LOGIN{$user_id}) {
        return $USER_ID2LOGIN{$user_id};
    } else {
        $USER_ID2LOGIN{$user_id} = $app->users->get($user_id)->{login};

        die "unknown user_id $user_id" unless $USER_ID2LOGIN{$user_id};
    }
}

sub output_lognis_and_roles {
    my ($app) = @_;

    my $users = $app->users->get_all(fields => [qw(login id roles adfox_info)],);

    foreach my $user (sort {$a->{login} cmp $b->{login}} @$users) {

        my $addition = '';

        if (@{$user->{adfox_info}}) {
            foreach my $ai (@{$user->{adfox_info}}) {
                $addition .= " Adfox login: $ai->{login} Adfox ID: $ai->{id};";
            }
        }

        note sprintf '## Login: %s (User ID %s)' . $addition, $user->{login}, $user->{id},;
        foreach my $role (@{$user->{roles}}) {
            note sprintf ' * %s - %s', $role->{id}, $role->{name};
        }
    }
    note '';
}

sub remove_new_lines {
    my ($string) = @_;

    $string =~ s/\n/ /g;
    return $string;
}

sub output_campaings_and_blocks {
    my ($app) = @_;

    my $campaign_accessor_names = $app->product_manager->get_page_model_accessors();
    foreach my $campaign_accessor_name (sort @$campaign_accessor_names) {
        next if $campaign_accessor_name =~ /ssp/;
        note "## $campaign_accessor_name";
        my $campaigns = $app->$campaign_accessor_name->get_all(
            fields => [qw(id page_id owner_id multistate multistate_name)],
            limit  => 3,
        );

        foreach my $c (@$campaigns) {

            note sprintf " * Page ID: %-10s Login: %-30s Multistate: %s (%s)",
              $c->{page_id},
              get_login_by_user_id($app, $c->{owner_id}),
              $c->{multistate},
              remove_new_lines($c->{multistate_name}),
              ;
            foreach my $block_accessor ($app->$campaign_accessor_name->get_block_models()) {
                my $blocks = $block_accessor->get_all(fields => [qw(public_id multistate multistate_name)],);
                foreach my $block (@$blocks) {
                    # Хак для того чтобы понять что этот блок принадлежит этой площадке
                    # Было бы хорошо если во всех моделях с блоком можно было бы получить
                    # список блоков по пейджу с помощью $block_accessor->get_all( filter => { page_id => $page_id } ),
                    if ($block->{public_id} =~ /-$c->{page_id}-/) {
                        note sprintf "   * %-20s %s Multistate: %s (%s)",
                          $block->{public_id} // '',
                          ' ' x 34,
                          $c->{multistate},
                          remove_new_lines($block->{multistate_name}),
                          ;
                    }
                }
            }
        }
        note '';

    }
}

run_tests(
    sub {
        my ($app) = @_;

        output_lognis_and_roles($app);
        output_campaings_and_blocks($app);

    },
);
