#!/usr/bin/perl -w

use qbit;

use FindBin qw($Bin);
use File::Finder;
use Test::More;

ok(TRUE, 'Loaded ok');    # to make Jenkins TAP plugin work

subtest(
    'Templates has correct extension.' => sub {
        my %excluded_files;
        @excluded_files{
            qw(
              templates/widget/statistics.tt2
              templates/main/redir.tt2
              )
          }
          = ();

        my $root_dir = "$Bin/..";
        foreach (File::Finder->type('f')->in("$root_dir/templates")) {
            s|^$root_dir/||;
            unless (exists($excluded_files{$_}) || m'/\.[^/]+\.swp$') {
                ok(/\.bem\.tt2$/, $_);
            }
        }
    }
);

done_testing();
exit;
