#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use FindBin qw($Bin);
use lib "$Bin/../lib";

use Test::Most;
use Test::More;
use Test::Deep;

use qbit;

use Utils::Tree;

my $data = [
    {
        id        => 0,
        parent_id => undef,
        name      => 'name 0'
    },
    {
        id        => 1,
        parent_id => 0,
        name      => 'name 1'
    },
    {
        id        => 2,
        parent_id => 0,
        name      => 'name 2'
    },
    {
        id        => 7,
        parent_id => 6,
        name      => 'name 7'
    },
    {
        id        => 5,
        parent_id => 3,
        name      => 'name 5'
    },
    {
        id        => 6,
        parent_id => 5,
        name      => 'name 6'
    },
    {
        id        => 4,
        parent_id => 3,
        name      => 'name 4'
    },
    {
        id        => 3,
        parent_id => 1,
        name      => 'name 3'
    },
];

my $tree = get_tree_by_array(clone($data));

my $str = '';
$tree->traverse(
    sub {
        my ($element) = @_;

        $str .= ("    " x $element->getDepth) . $element->getNodeValue()->{'name'} . "\n";
    }
);

is(
    $str, "name 0
    name 1
        name 3
            name 5
                name 6
                    name 7
            name 4
    name 2
", 'Tree right'
);

cmp_bag(get_array_by_tree($tree), $data, 'Tree right');

foreach (@$data) {
    $_->{'uid'} = delete($_->{'id'});
    $_->{'pid'} = delete($_->{'parent_id'});
}

$tree = get_tree_by_array(clone($data), id_key_name => 'uid', parent_id_key_name => 'pid',);

cmp_bag(get_array_by_tree($tree), $data, 'Tree right with not default keys');

done_testing();
exit;
